<?php

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'install', 'middleware' => 'web'], function () {
    Route::get('/', 'App\Http\Controllers\InstallerController@index')->name('installer.index');
    Route::get('/requirements', 'App\Http\Controllers\InstallerController@requirements')->name('installer.requirements');
    Route::get('/license', 'App\Http\Controllers\InstallerController@license')->name('installer.license');
    Route::post('/license', 'App\Http\Controllers\InstallerController@verifyLicense')->name('installer.verify_license');
    Route::get('/database', 'App\Http\Controllers\InstallerController@database')->name('installer.database');
    Route::post('/database', 'App\Http\Controllers\InstallerController@setDatabase')->name('installer.set_database');
    Route::get('/app', 'App\Http\Controllers\InstallerController@app')->name('installer.app');
    Route::post('/app', 'App\Http\Controllers\InstallerController@setApp')->name('installer.set_app');
    Route::get('/install', 'App\Http\Controllers\InstallerController@install')->name('installer.install');
    Route::post('/install', 'App\Http\Controllers\InstallerController@doInstall')->name('installer.do_install');
    Route::get('/complete', 'App\Http\Controllers\InstallerController@complete')->name('installer.complete');
});
